/*
 *  XslFoBuilder.java
 *  Copyright (C) 2005 Amin Ahmad. 
 *          
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 *  Amin Ahmad can be contacted at amin.ahmad@gmail.com or on the web at 
 *  www.ahmadsoft.org.
 */
package org.ahmadsoft.foprocessor.builders;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

import org.ahmadsoft.foprocessor.FoProcessorPlugin;
import org.ahmadsoft.foprocessor.core.FileRenderSpecification;
import org.ahmadsoft.foprocessor.operations.ConversionOperation;
import org.ahmadsoft.foprocessor.operations.ConversionOperation.Listener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/**
 * Builds FO resources.
 */
public class XslFoBuilder extends IncrementalProjectBuilder implements Listener {

	@Override
	protected IProject[] build(int kind, Map args, IProgressMonitor monitor)
			throws CoreException {
		
		Set<FileRenderSpecification> buildSet = getBuildSet(getDelta(getProject()));
		ConversionOperation build = new ConversionOperation(buildSet, monitor, this);
		build.run();
		
		return null;
	}
	
	private Set<FileRenderSpecification> getBuildSet(IResourceDelta root) {
		Set<FileRenderSpecification> result = new HashSet<FileRenderSpecification>();
		
		Stack<IResourceDelta> toExamine = new Stack<IResourceDelta>();
		toExamine.push(root);
		while (toExamine.size() != 0) {
			IResourceDelta delta = toExamine.pop();
			if (delta.getResource() instanceof IFile) {
				IFile fileResource = (IFile) delta.getResource();
				boolean isAutoBuild = false;
				try {
					isAutoBuild = FoProcessorPlugin.getDefault().isAutoBuild(fileResource);
					FileRenderSpecification buildSpec = FoProcessorPlugin.getDefault().getBuildSpec(fileResource);
					if (isAutoBuild && buildSpec != null) {
						result.add(buildSpec);
					}
				} catch (CoreException e) {
					// do nothing
				}
			}
			IResourceDelta[] affectedChildren = delta.getAffectedChildren();
			for (IResourceDelta child: affectedChildren) {
				toExamine.push(child);
			}
		}
		
		return result;
	}

	public void onFinish() {
		// TODO Auto-generated method stub
		
	}

	public void onError(String msg, Throwable throwable) {
		// TODO Auto-generated method stub
		
	}

}
