/*
 *  FoProcessorPlugin.java
 *  Copyright (C) 2005 Amin Ahmad. 
 *          
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 *  Amin Ahmad can be contacted at amin.ahmad@gmail.com or on the web at 
 *  www.ahmadsoft.org.
 */

package org.ahmadsoft.foprocessor;
import java.net.URL;

import org.ahmadsoft.foprocessor.core.FileRenderSpecification;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * This is the central singleton for the Workspace edit plugin.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public final class FoProcessorPlugin extends AbstractUIPlugin {
    
	public static final String FOP_NATURE = "org.ahmadsoft.foprocessor.fopNature";
	public static final String BUILD_MARKER = "org.ahmadsoft.foprocessor.fopMarker";
	public static final String FOP_RENDERER = "org.ahmadsoft.foprocessor.fopBuilder";
	
    /**
     * Keep track of the singleton.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private static FoProcessorPlugin INSTANCE;

    /**
     * Create the instance.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public FoProcessorPlugin() {
        super();
        INSTANCE = this;
    }
    
    public static FoProcessorPlugin getDefault() {
        return INSTANCE;
    }
    
    public ImageDescriptor getImageDescriptor(String path) {
        URL baseURL = getBundle().getEntry("/icons/" + path); //$NON-NLS-1$    
        ImageDescriptor desc = ImageDescriptor.createFromURL(baseURL);
        return desc;
    }
    
    public void start(BundleContext context) throws Exception {
        super.start(context);
    }
    
    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }
    
    public void addFopNature(IProject project) throws CoreException {
    	if (project.hasNature(FOP_NATURE))
    		return;
    	
    	IProjectDescription description = project.getDescription();
    	String[] ids = description.getNatureIds();
    	String[] newIds = new String[ids.length + 1];
    	System.arraycopy(ids, 0, newIds, 0, ids.length);
    	newIds[ids.length] = FOP_NATURE;
    	description.setNatureIds(newIds);
    	project.setDescription(description, null);
    }
    
    public boolean isAutoBuild(IFile inputFile) throws CoreException {
        IMarker[] markers = inputFile.findMarkers(FoProcessorPlugin.BUILD_MARKER, false, IResource.DEPTH_ZERO);
        if (markers.length == 0)
        	return false;
        IMarker marker = markers[0];
        Object buildValue = marker.getAttribute("build");
        if (buildValue == null || !(buildValue instanceof Boolean)) 
        	return false;
        
        return ((Boolean) buildValue).booleanValue();
    }
    
    public FileRenderSpecification getBuildSpec(IFile inputFile) throws CoreException {
        IMarker[] markers = inputFile.findMarkers(FoProcessorPlugin.BUILD_MARKER, false, IResource.DEPTH_ZERO);
        if (markers.length == 0)
        	return null;
        IMarker marker = markers[0];
        Object buildValue = marker.getAttribute("buildSpec");
        if (buildValue == null || !(buildValue instanceof String)) 
        	return null;
        
        return FileRenderSpecification.fromString(inputFile, (String) buildValue);
    }
    
    public void setAutoBuild(IFile inputFile, boolean value, FileRenderSpecification spec) throws CoreException {
    	if (value == true) {
	        IMarker[] markers = inputFile.findMarkers(FoProcessorPlugin.BUILD_MARKER, false, IResource.DEPTH_ZERO);
	        IMarker marker;
	        if (markers.length == 0) {
	        	marker = inputFile.createMarker(FoProcessorPlugin.BUILD_MARKER);
	        } else {
	        	marker = markers[0];
	        }
	        marker.setAttribute("build",true);
	        marker.setAttribute("buildSpec",FileRenderSpecification.toString(spec));
    	} else {
            inputFile.deleteMarkers(FoProcessorPlugin.BUILD_MARKER, false, IResource.DEPTH_ZERO);
    	}
    }
}
