/*
 *  FopNature.java
 *  Copyright (C) 2005 Amin Ahmad. 
 *          
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 *  Amin Ahmad can be contacted at amin.ahmad@gmail.com or on the web at 
 *  www.ahmadsoft.org.
 */
package org.ahmadsoft.foprocessor.natures;

import org.ahmadsoft.foprocessor.FoProcessorPlugin;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;

/**
 * FOP project nature.
 * @author Amin Ahmad
 */
public class FopNature implements IProjectNature {

	private IProject project;
	
	public void configure() throws CoreException {
		IProjectDescription description = getProject().getDescription();
		ICommand[] commands= description.getBuildSpec();
		for (ICommand command: commands) {
			if (command.getBuilderName().equals(FoProcessorPlugin.FOP_RENDERER))
				return;
		}
		
		ICommand command = description.newCommand();
		command.setBuilderName(FoProcessorPlugin.FOP_RENDERER);;
		ICommand[] newCommands = new ICommand[commands.length+1];
		System.arraycopy(commands, 0, newCommands, 0, commands.length);
		newCommands[commands.length]= command;
		description.setBuildSpec(newCommands);
		getProject().setDescription(description, null);
	}

	public void deconfigure() throws CoreException {
		IProjectDescription description = getProject().getDescription();
		ICommand[] commands= description.getBuildSpec();
		ICommand[] newCommands = new ICommand[commands.length-1];
		
		for (int j=0;j<commands.length;++j) { 
			ICommand command = commands[j];
			if (command.getBuilderName().equals(FoProcessorPlugin.FOP_RENDERER)) {
				System.arraycopy(commands, 0, newCommands, 0, j);
				System.arraycopy(commands, j, newCommands, j, commands.length - j - 1);
				description.setBuildSpec(newCommands);
				getProject().setDescription(description, null);
				return;
			}
		}
		
	}

	public IProject getProject() {
		return project;
	}

	public void setProject(IProject project) {
		this.project=project;
	}

}
