/*
 *  ActionUtils.java
 *  Copyright (C) 2005 Amin Ahmad. 
 *          
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 *  Amin Ahmad can be contacted at amin.ahmad@gmail.com or on the web at 
 *  www.ahmadsoft.org.
 */

package org.ahmadsoft.foprocessor.popup.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.ahmadsoft.foprocessor.core.FileRenderSpecification;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * Miscellaneous utilities for actions.
 * @author Amin Ahmad
 */
public class ActionUtils {
	public static final List<FileRenderSpecification> asRenderSpecs(String mimeType, String extension, ISelection selection) {
		List<FileRenderSpecification> result = new ArrayList<FileRenderSpecification>();
		
		if (selection instanceof IStructuredSelection) {
			IStructuredSelection structuredSelection = (IStructuredSelection) selection;
	        for (Iterator i = structuredSelection.iterator(); i.hasNext();) {
	        	IResource resource = (IResource) i.next();
	        	if (resource instanceof IFile) {
	        		IFile file = (IFile) resource;

	            	FileRenderSpecification renderSpec = new FileRenderSpecification();
	            	renderSpec.setInputFile(file);
	            	renderSpec.setOutputFile(FileRenderSpecification.computeOutputFile(file, extension));
	            	renderSpec.setMimeType(mimeType);
	            	result.add(renderSpec);
	        	}
	        }
		}
		
		return result;
	}
}
